-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles
myself, the author, to unlimited free and unrestricted use,
access, and distribution of any works related to the unauthorized
user and/or distributor.

--]]

THToggleRowShutoffEvent = {}
local THToggleRowShutoffEvent_mt = Class(THToggleRowShutoffEvent, Event)
THUtils.initClass(THToggleRowShutoffEvent, "THToggleRowShutoffEvent", THClassType.EVENT)
function THToggleRowShutoffEvent.emptyNew()
    return Event.new(THToggleRowShutoffEvent_mt)
end
function THToggleRowShutoffEvent.new(vehicle, isEnabled)
    local self = THToggleRowShutoffEvent.emptyNew()
    self.isEventValid = false
    if THUtils.argIsValid(THUtils.getIsType(vehicle, Vehicle), "vehicle", vehicle)
        and THUtils.argIsValid(not isEnabled or isEnabled == true, "isEnabled", isEnabled)
    then
        self.vehicle = vehicle
        self.isEnabled = isEnabled == true
        self.isEventValid = true
    end
    return self
end
function THToggleRowShutoffEvent.readStream(self, streamId, connection)
    if streamReadBool(streamId) then
        self.vehicle = NetworkUtil.readNodeObject(streamId)
        self.isEnabled = streamReadBool(streamId)
        self:run(connection)
    end
end
function THToggleRowShutoffEvent.writeStream(self, streamId, connection)
    if streamWriteBool(streamId, self.isEventValid == true) then
        NetworkUtil.writeNodeObject(streamId, self.vehicle)
        streamWriteBool(streamId, self.isEnabled)
    end
end
function THToggleRowShutoffEvent.run(self, connection)
    THUtils.pcall(function()
        if connection:getIsServer() then
            THToggleRowShutoffEvent.sendEvent(self.vehicle, self.isEnabled, connection)
        else
            THVSpec_RowCropWorkArea.setIsRowShutoffEnabled(self.vehicle, self.isEnabled)
        end
    end)
end
function THToggleRowShutoffEvent.sendEvent(vehicle, isEnabled, connection)
    local newEvent = THToggleRowShutoffEvent.new(vehicle, isEnabled)
    local success = false
    if newEvent ~= nil and newEvent.isEventValid then
        success = true
        if g_server ~= nil then
            g_server:broadcastEvent(newEvent, false, connection, vehicle)
        elseif g_client ~= nil then
            g_client:getServerConnection():sendEvent(newEvent)
        else
            success = false
        end
        if success then
            THVSpec_RowCropWorkArea.setIsRowShutoffEnabled(newEvent.vehicle, newEvent.isEnabled)
        end
    end
    return success
end